-- elements that are shared between the ScreenEditSpeedMods variants.
-- I really don't like repeating myself.
local menuState = {
	Mode = "Main",		-- menu mode. ("Main", "Edit")
	SubMode = nil,		-- sub mode ("Add","Edit","Delete")
	CurIndex = 1,		-- index in main menu
	ListIndex = 1,		-- index in sub menu (Speed Mod List)
	InputIndex = nil,	-- index in speed mod editor. (mod type)
	SpeedModType = nil, -- speed mod type ("X","C","M")
	NumpadX = 1,		-- numpad column
	NumpadY = 1,		-- numpad row
}

local mainStates = { "Main", "Edit" } -- Main=top 3, Edit=Edit pad
local subItems = { "Add", "Edit", "Delete" }

local NumpadMap = {
	{ "1", "2", "3", "<", nil			 }, -- impossible to get to top right
	{ "4", "5", "6", ".", "NumPadOK"	 },
	{ "7", "8", "9", "0", "NumPadCancel" },
}

local mainButtonFont = "_francophilsans Bold 24px"
local modButtonFont = "_dejavu sans Bold 24px"

local function numButton(n)
	return Def.ActorFrame{
		Name="NumPad"..n;

		LoadActor(THEME:GetPathG("_speedmod","numitem"))..{
			Name="Button";
		};
		LoadFont(modButtonFont)..{
			Name="Text";
			Text=n;
			InitCommand=cmd(shadowlength,2;zoom,20/24);
			-- fix the positioning of the backspace character:
			BeginCommand=function(self) if n == "<" then self:x(-1) self:y(-2) end end;
		};
	};
end

return Def.ActorFrame{
	Def.Actor{
		Name="InputController";
		MenuInputMessageCommand=function(self,param)
			local curMode = menuState.Mode
			local subMode = menuState.SubMode
			if param.Input == "Start" then
				-- handle mode switching
				if curMode == "Main" then
					if subMode == nil then
						local curIndex = menuState.CurIndex
						menuState.SubMode = subItems[curIndex]
						if subMode == "Add" then
							-- add a new speed mod
							menuState.Mode = "Edit"
						elseif subMode == "Edit" then
							-- edit the selected speed mod
							menuState.Mode = "Edit"
						elseif subMode == "Delete" then
							-- ask if they want to delete the speed mod, unless it's 1x
						end
					else
						-- check submode
					end
				elseif curMode == "Edit" then
					
				end
			elseif param.Input == "Back" then
				-- handle back
			else
				if subMode == nil then
					-- main input
					if param.Input == "Left" then
						local idx = menuState.CurIndex
						local oldIdx = idx
						if idx - 1 < 1 then
							idx = #subItems
						else
							idx = idx - 1
						end
						MESSAGEMAN:Broadcast("MainMenuMove",{ New=idx, Old=oldIdx })
						menuState.CurIndex = idx
					elseif param.Input == "Right" then
						local idx = menuState.CurIndex
						local oldIdx = idx
						if idx + 1 > #subItems then
							idx = 1
						else
							idx = idx + 1
						end
						MESSAGEMAN:Broadcast("MainMenuMove",{ New=idx, Old=oldIdx })
						menuState.CurIndex = idx
					elseif param.Input == "Up" then
						MESSAGEMAN:Broadcast("ListInput",{ Index = menuState.ListIndex, Dir = "Up" })
					elseif param.Input == "Down" then
						MESSAGEMAN:Broadcast("ListInput",{ Index = menuState.ListIndex, Dir = "Down" })
					end
				else
					if curMode == "Edit" then
						if menuState.SpeedModType == nil then
							-- need to pick speed mod type
						else
							
						end
					else
						-- non-start input for a different mode
					end
				end
			end
		end;
		MenuUpP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Up", }); end;
		MenuUpP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Up", }); end;
		MenuDownP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Down", }); end;
		MenuDownP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Down", }); end;
		MenuLeftP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Left", }); end;
		MenuLeftP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Left", }); end;
		MenuRightP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Right", }); end;
		MenuRightP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Right", }); end;
		CodeMessageCommand=function(self,param)
			MESSAGEMAN:Broadcast("MenuInput", { Player = param.PlayerNumber, Input = param.Name })
		end;
		-- otherworld input:
		ListIndexMessageCommand=function(self,p)
			menuState.ListIndex = p.New
		end;
	};

	-- Add, Edit, and Delete buttons
	Def.ActorFrame{
		Name="MainButtons";
		InitCommand=cmd(xy,SCREEN_CENTER_X+48,SCREEN_CENTER_Y-148;);
		BeginCommand=function(self)
			--menuState.CurIndex
			local c = self:GetChildren()
			c.ButtonAdd:playcommand("GainFocus")
			c.ButtonEdit:playcommand("LoseFocus")
			c.ButtonDelete:playcommand("LoseFocus")
		end;
		MainMenuMoveMessageCommand=function(self,p)
			local old, new = p.Old, p.New
			local c = self:GetChildren()
			c.ButtonAdd:playcommand(new == 1 and "GainFocus" or "LoseFocus")
			c.ButtonEdit:playcommand(new == 2 and "GainFocus" or "LoseFocus")
			c.ButtonDelete:playcommand(new == 3 and "GainFocus" or "LoseFocus")
		end;

		Def.ActorFrame{
			Name="ButtonAdd";
			InitCommand=cmd(x,-108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Add");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
		Def.ActorFrame{
			Name="ButtonEdit";
			InitCommand=cmd();
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Edit");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
		Def.ActorFrame{
			Name="ButtonDelete";
			InitCommand=cmd(x,108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Delete");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
	};

	-- display section

	-- speed mod type buttons
	Def.ActorFrame{
		Name="ModTypeButtons";
		InitCommand=cmd(xy,SCREEN_CENTER_X+48,SCREEN_CENTER_Y-36;);

		Def.ActorFrame{
			Name="xMod";
			InitCommand=cmd(x,-108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"xMod");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};

		Def.ActorFrame{
			Name="cMod";
			InitCommand=cmd(x,0;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"C-Mod");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};

		Def.ActorFrame{
			Name="mMod";
			InitCommand=cmd(x,108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"m-Mod");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
	};

	-- the number pad
	Def.ActorFrame{
		Name="NumPad";
		InitCommand=cmd(xy,SCREEN_CENTER_X+54,SCREEN_CENTER_Y+16;);
		-- row 1
		numButton("1")..{ InitCommand=cmd(xy,-120,0;);	};
		numButton("2")..{ InitCommand=cmd(xy,-80,0;);	};
		numButton("3")..{ InitCommand=cmd(xy,-40,0;);	};
		numButton("<")..{ InitCommand=cmd(xy,0,0;);		};
		-- row 2
		numButton("4")..{ InitCommand=cmd(xy,-120,40;);	};
		numButton("5")..{ InitCommand=cmd(xy,-80,40;);	};
		numButton("6")..{ InitCommand=cmd(xy,-40,40;);	};
		numButton(".")..{ InitCommand=cmd(xy,0,40;);	};
		-- row 3
		numButton("7")..{ InitCommand=cmd(xy,-120,80;);	};
		numButton("8")..{ InitCommand=cmd(xy,-80,80;);	};
		numButton("9")..{ InitCommand=cmd(xy,-40,80;);	};
		numButton("0")..{ InitCommand=cmd(xy,0,80;);	};

		-- buttons
		Def.ActorFrame{
			Name="NumPadOK";
			InitCommand=cmd(xy,76,40;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"OK");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
		Def.ActorFrame{
			Name="NumPadCancel";
			InitCommand=cmd(xy,76,80;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Cancel");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
	};

	-- instructions text
	LoadFont("_francophilsans Bold 24px")..{
		InitCommand=cmd(xy,SCREEN_CENTER_X+46,SCREEN_CENTER_Y+156;shadowlength,1;zoom,16/24);
		BeginCommand=cmd(settext,"&LEFT;&RIGHT; Changes Option / &UP;&DOWN; Changes Speed Mod");
	};
};